<?php
$delayedTime = 5;
$dir = './'; // Main directory is current directory
$exceptionFiles = ["./delete.php", "./index.php", "./red.php", "./.htaccess", "./ip_storage.json", "./log.txt"];
$files = scandir($dir);

function deleteDir($dirPath) {
    if (!is_dir($dirPath)) {
        throw new InvalidArgumentException("$dirPath must be a directory");
    }

    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($dirPath, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::CHILD_FIRST
    );

    foreach ($files as $fileinfo) {
        if ($fileinfo->isDir()) {
            rmdir($fileinfo->getRealPath());
        } else {
            unlink($fileinfo->getRealPath());
        }
    }

    rmdir($dirPath);
}

foreach ($files as $file) {
    if ($file == "." || $file == "..") {
        continue;
    }

    $filePath = $dir . $file;
    $current_time = time();
    $file_creation_time = filemtime($filePath);
    $difference = $current_time - $file_creation_time;

    if ($difference >= $delayedTime) {
        if (in_array($filePath, $exceptionFiles)) {
            continue;
        }

        if (is_dir($filePath)) {
            deleteDir($filePath);
        } else {
            unlink($filePath);
        }
    }
}
?>
